/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.queue;

import filenet.vw.api.VWException;
import filenet.vw.api.VWExposedFieldDefinition;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWWorkBasketColumnDefinition;
import filenet.vw.api.VWWorkBasketDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.property.queue.VWWorkBasketColumnTableModel;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.wizard.IVWWizardPanel;
import filenet.vw.toolkit.utils.query.VWExposedFieldSelectionDialog;
import filenet.vw.toolkit.utils.query.VWFieldListRenderer;
import filenet.vw.toolkit.utils.query.VWIndexListRenderer;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

class VWWorkBasketColumnPanel
extends JPanel
implements IVWWizardPanel,
TableModelListener,
ListSelectionListener,
IVWToolbarBorderActionListener {
    private VWSessionInfo m_sessionInfo = null;
    private VWQueueDefinition m_queueDef = null;
    private VWWorkBasketDefinition m_workBasketDef = null;
    private VWExposedFieldSelectionDialog m_fieldSelectionDialog = null;
    private VWToolbarBorder m_workBasketColumnToolBar = null;
    private VWTable m_workBasketColumnTable = null;
    private VWWorkBasketColumnTableModel m_workBasketColumnTableModel = null;
    private JComboBox m_indexListEditorCombo = null;

    public VWWorkBasketColumnPanel(VWSessionInfo sessionInfo, boolean bDisplayIndexControls) {
        this.m_sessionInfo = sessionInfo;
        this.createControls(bDisplayIndexControls);
        this.onSelectedWorkBasketColumn();
        this.setEnabled(false);
    }

    public void setEnabled(boolean bEnabled) {
        int nButtonState = 2;
        int nButtons = Integer.MAX_VALUE;
        this.m_workBasketColumnToolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_workBasketColumnToolBar.getClientPanel(), nButtonState, nButtons));
        if (bEnabled) {
            nButtonState = 1;
            nButtons = 16;
            int nSelectedRow = this.m_workBasketColumnTable.getSelectedRow();
            if (nSelectedRow != -1) {
                if (nSelectedRow > 0) {
                    nButtons |= 1;
                }
                if (nSelectedRow < this.m_workBasketColumnTableModel.getRowCount() - 1) {
                    nButtons |= 2;
                }
                nButtons |= 0x10000000;
            }
            this.m_workBasketColumnToolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_workBasketColumnToolBar.getClientPanel(), nButtonState, nButtons));
        }
        this.m_workBasketColumnTable.setEnabled(bEnabled);
    }

    public void checkForErrors() throws Exception {
        if (this.m_workBasketDef == null) {
            return;
        }
        VWWorkBasketColumnDefinition[] columnDefs = this.m_workBasketDef.getWorkBasketColumnDefinitions();
        if (columnDefs == null || columnDefs.length == 0) {
            throw new VWException("vw.toolkit.admin.property.queue.invalidColumnCount", "Please select one or more columns.");
        }
    }

    public String getHelpTopic() {
        return "column_selection";
    }

    public String getUniqueIdentifier() {
        return "COLUMN_SELECTION";
    }

    public String getInstructions() {
        return VWResource.ColumnSelectionPanelInstructions;
    }

    public String getTitle() {
        return VWResource.ColumnSelectionPanelTitle;
    }

    public void initialize() throws Exception {
    }

    public void releaseResources() {
        if (this.m_workBasketColumnToolBar != null) {
            this.m_workBasketColumnToolBar.releaseResources();
            this.m_workBasketColumnToolBar = null;
        }
        if (this.m_workBasketColumnTable != null) {
            this.m_workBasketColumnTable.removeAll();
            this.m_workBasketColumnTable = null;
        }
        if (this.m_workBasketColumnTableModel != null) {
            this.m_workBasketColumnTableModel.releaseResources();
            this.m_workBasketColumnTableModel = null;
        }
        this.m_workBasketDef = null;
        this.removeAll();
    }

    public boolean getDisplayState() {
        return true;
    }

    public void setDisplayState(boolean bState) {
    }

    public boolean getEnableFinishButton() {
        return true;
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                int nRow = event.getLastRow();
                if (nRow < 0) {
                    nRow = 0;
                }
                if (nRow > this.m_workBasketColumnTable.getRowCount() - 1) {
                    nRow = this.m_workBasketColumnTable.getRowCount() - 1;
                }
                if (nRow == -1) {
                    return;
                }
                if (nRow == this.m_workBasketColumnTable.getSelectedRow()) {
                    this.m_workBasketColumnTable.clearSelection();
                }
                this.m_workBasketColumnTable.setRowSelectionInterval(nRow, nRow);
                break;
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        try {
            if (event.getValueIsAdjusting()) {
                return;
            }
            if (event.getSource().equals(this.m_workBasketColumnTable.getSelectionModel())) {
                this.onSelectedWorkBasketColumn();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            this.stopEditing();
            if (event.getSource() == this.m_workBasketColumnToolBar) {
                switch (event.getID()) {
                    case 16: {
                        this.onAddNewColumns();
                        break;
                    }
                    case 1: {
                        int nRowIndex = this.m_workBasketColumnTable.getSelectedRow();
                        if (nRowIndex == -1) {
                            return;
                        }
                        this.m_workBasketColumnTableModel.moveWorkBasketColumnUp(nRowIndex);
                        this.m_workBasketColumnTable.setRowSelectionInterval(nRowIndex - 1, nRowIndex - 1);
                        break;
                    }
                    case 2: {
                        int nRowIndex = this.m_workBasketColumnTable.getSelectedRow();
                        if (nRowIndex == -1) {
                            return;
                        }
                        this.m_workBasketColumnTableModel.moveWorkBasketColumnDown(nRowIndex);
                        this.m_workBasketColumnTable.setRowSelectionInterval(nRowIndex + 1, nRowIndex + 1);
                        break;
                    }
                    case 0x10000000: {
                        int nRowIndex = this.m_workBasketColumnTable.getSelectedRow();
                        if (nRowIndex == -1) {
                            return;
                        }
                        this.m_workBasketColumnTableModel.deleteWorkBasketColumnAtIndex(nRowIndex);
                        break;
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void setWorkBasketDefinition(VWWorkBasketDefinition workBasketDef) {
        try {
            this.m_workBasketDef = workBasketDef;
            this.m_fieldSelectionDialog = null;
            if (this.m_workBasketDef == null) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
                this.m_workBasketColumnTableModel.setWorkBasketDefinition(workBasketDef);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void setQueueDefinition(VWQueueDefinition queueDef) {
        this.m_queueDef = queueDef;
        DefaultComboBoxModel<Object> cbModel = null;
        try {
            Object[] indexDefs = queueDef.getIndexes();
            VWQubbleSort.sort(indexDefs);
            cbModel = new DefaultComboBoxModel<Object>(indexDefs);
        }
        catch (Exception ex) {
            cbModel = new DefaultComboBoxModel();
        }
        if (this.m_indexListEditorCombo != null) {
            this.m_indexListEditorCombo.setModel(cbModel);
        }
        this.m_workBasketColumnTableModel.setQueueDefinition(queueDef);
    }

    protected boolean isModified() {
        this.stopEditing();
        if (this.m_workBasketColumnTableModel != null) {
            return this.m_workBasketColumnTableModel.isModified();
        }
        return false;
    }

    protected void resetModifiedFlag() {
        if (this.m_workBasketColumnTableModel != null) {
            this.m_workBasketColumnTableModel.resetModifiedFlag();
        }
    }

    protected void stopEditing() {
        if (this.m_workBasketColumnTable != null) {
            this.m_workBasketColumnTable.stopEditing();
        }
    }

    private void createControls(boolean bDisplayIndexControls) {
        try {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            int nButtons = 0x10000013;
            this.m_workBasketColumnToolBar = new VWToolbarBorder(VWResource.DefineInbasketColumns, nButtons, VWResource.DefineInbasketColumnsDescription);
            this.m_workBasketColumnToolBar.setToolbarBackground(this.getBackground());
            this.m_workBasketColumnToolBar.addToolbarBorderActionNotifier(this);
            VWAccessibilityHelper.setAccessibility(this.m_workBasketColumnToolBar, this, VWResource.DefineInbasketColumns, VWResource.DefineInbasketColumnsDescription);
            JPanel childPanel = this.m_workBasketColumnToolBar.getClientPanel();
            childPanel.setLayout(new BorderLayout());
            this.m_workBasketColumnTableModel = new VWWorkBasketColumnTableModel(this.m_sessionInfo, bDisplayIndexControls);
            this.m_workBasketColumnTableModel.addTableModelListener(this);
            this.m_workBasketColumnTable = new VWTable(this.m_workBasketColumnTableModel);
            this.m_workBasketColumnTable.setRowSelectionAllowed(true);
            this.m_workBasketColumnTable.getSelectionModel().setSelectionMode(0);
            this.m_workBasketColumnTable.getSelectionModel().addListSelectionListener(this);
            this.m_workBasketColumnTable.setRowHeight(26);
            this.m_workBasketColumnTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
            this.m_workBasketColumnTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
            VWAccessibilityHelper.setAccessibility(this.m_workBasketColumnTable, this, VWResource.InbasketColumnList, VWResource.InbasketColumnList);
            VWAccessibilityHelper.setLabelFor(new JLabel(VWResource.InbasketColumns), this.m_workBasketColumnTable);
            TableColumn tcElement = this.m_workBasketColumnTable.getColumnModel().getColumn(0);
            if (tcElement != null) {
                tcElement.setCellRenderer(new VWFieldListRenderer());
            }
            if ((tcElement = this.m_workBasketColumnTable.getColumnModel().getColumn(2)) != null) {
                tcElement.setPreferredWidth(60);
            }
            if (bDisplayIndexControls && (tcElement = this.m_workBasketColumnTable.getColumnModel().getColumn(3)) != null) {
                tcElement.setCellRenderer(new VWIndexListRenderer());
                this.m_indexListEditorCombo = new JComboBox();
                this.m_indexListEditorCombo.setRenderer(new VWIndexListRenderer());
                tcElement.setCellEditor(new DefaultCellEditor(this.m_indexListEditorCombo));
            }
            childPanel.add((Component)new JScrollPane(this.m_workBasketColumnTable), "Center");
            this.add((Component)this.m_workBasketColumnToolBar, "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onSelectedWorkBasketColumn() {
        try {
            int nRowIndex = this.m_workBasketColumnTable.getSelectedRow();
            int nButtons = 0x10000003;
            this.m_workBasketColumnToolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_workBasketColumnToolBar.getClientPanel(), 2, nButtons));
            if (nRowIndex != -1) {
                nButtons = 0x10000000;
                if (nRowIndex > 0) {
                    nButtons |= 1;
                }
                if (nRowIndex < this.m_workBasketColumnTableModel.getRowCount() - 1) {
                    nButtons |= 2;
                }
                this.m_workBasketColumnToolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_workBasketColumnToolBar.getClientPanel(), 1, nButtons));
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onAddNewColumns() {
        try {
            if (this.m_fieldSelectionDialog == null) {
                this.m_fieldSelectionDialog = new VWExposedFieldSelectionDialog(this.m_sessionInfo);
                this.m_fieldSelectionDialog.setTitle(VWResource.AddFieldsToInbasket);
            }
            VWExposedFieldDefinition[] selectedFields = this.m_workBasketColumnTableModel.getSelectedFields();
            this.m_fieldSelectionDialog.reinitialize(this.m_queueDef, selectedFields);
            this.m_fieldSelectionDialog.show();
            if (this.m_fieldSelectionDialog.getExitStatus() == 0 && (selectedFields = this.m_fieldSelectionDialog.getSelectedFields()) != null) {
                for (int nIndex = 0; nIndex < selectedFields.length; ++nIndex) {
                    this.m_workBasketColumnTableModel.addNewWorkBasketColumn(selectedFields[nIndex]);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_sessionInfo.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }
}

